/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.util.Enumeration;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.objects.MoveableObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PrimitiveLineObject;

public class TwoPointLineObject
extends PrimitiveLineObject
implements MoveableObject {
    protected PointObject P2;
    double X2;
    double Y2;
    double R;
    double x1;
    double y1;
    double x2;
    double y2;
    double x3;
    double y3;

    public TwoPointLineObject(Construction construction, PointObject pointObject, PointObject pointObject2) {
        super(construction);
        this.P1 = pointObject;
        this.P2 = pointObject2;
    }

    public PointObject getP2() {
        return this.P2;
    }

    public Enumeration depending() {
        super.depending();
        return this.depset(this.P1, this.P2);
    }

    public double getLength() {
        return this.R;
    }

    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.P2 = (PointObject)this.P2.getTranslation();
    }

    public boolean contains(PointObject pointObject) {
        return this.P1 == pointObject || this.P2 == pointObject;
    }

    public Enumeration secondaryParams() {
        DL.reset();
        return this.depset(this.P1, this.P2);
    }

    public void dragTo(double d2, double d3) {
        this.P1.move(this.x1 + (d2 - this.x3), this.y1 + (d3 - this.y3));
        this.P2.move(this.x2 + (d2 - this.x3), this.y2 + (d3 - this.y3));
    }

    public void move(double d2, double d3) {
    }

    public boolean moveable() {
        return this.P1.moveable() && this.P2.moveable();
    }

    public void startDrag(double d2, double d3) {
        this.x1 = this.P1.getX();
        this.y1 = this.P1.getY();
        this.x2 = this.P2.getX();
        this.y2 = this.P2.getY();
        this.x3 = d2;
        this.y3 = d3;
    }

    public void snap(ZirkelCanvas zirkelCanvas) {
        if (this.moveable()) {
            this.P1.snap(zirkelCanvas);
            this.P2.snap(zirkelCanvas);
        }
    }
}

