/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.expression;

import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.BasicExpression;
import rene.zirkel.expression.ElementaryExpression;
import rene.zirkel.expression.ExpressionText;
import rene.zirkel.expression.PotenzExpression;

class MinusExpression
extends ElementaryExpression {
    BasicExpression E;

    public MinusExpression(BasicExpression basicExpression) {
        this.E = basicExpression;
    }

    public double getValue() throws ConstructionException {
        return -this.E.getValue();
    }

    public static BasicExpression scan(ExpressionText expressionText) throws ConstructionException {
        if (expressionText.next() != '-') {
            return PotenzExpression.scan(expressionText);
        }
        expressionText.advance();
        BasicExpression basicExpression = PotenzExpression.scan(expressionText);
        return new MinusExpression(basicExpression);
    }

    public void translate() {
        this.E.translate();
    }

    public String toString() {
        return "-" + this.E.toString();
    }

    public boolean isNumber() {
        return this.E.isNumber();
    }

    public void reset() {
        this.E.reset();
    }
}

