/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import java.util.Random;
import org.javia.arity.ArityException;
import org.javia.arity.Function;
import org.javia.arity.MoreMath;
import org.javia.arity.VM;

class CompiledFunction
extends Function {
    static final int MAX_STACK_SIZE = 128;
    private static Random random = new Random();
    private double[] consts;
    private Function[] funcs;
    private byte[] code;
    private int arity;
    private static final ThreadLocal stacks = new ThreadLocal();
    static final double[] NO_ARGS = new double[0];

    CompiledFunction(int n, byte[] byArray, double[] dArray, Function[] functionArray) {
        this.init(n, byArray, dArray, functionArray);
    }

    CompiledFunction() {
        this.init(0, null, null, null);
    }

    void init(int n, byte[] byArray, double[] dArray, Function[] functionArray) {
        this.arity = n;
        this.code = byArray;
        this.consts = dArray;
        this.funcs = functionArray;
    }

    public int arity() {
        return this.arity;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        if (this.arity != 0) {
            stringBuffer.append("arity ").append(this.arity).append("; ");
        }
        for (int i = 0; i < this.code.length; ++i) {
            byte by = this.code[i];
            stringBuffer.append(VM.opcodeName[by]);
            if (by == 1) {
                stringBuffer.append(' ').append(this.consts[n++]);
            } else if (by == 2) {
                ++n2;
            }
            stringBuffer.append("; ");
        }
        if (n != this.consts.length) {
            stringBuffer.append("\nuses only ").append(n).append(" consts out of ").append(this.consts.length);
        }
        if (n2 != this.funcs.length) {
            stringBuffer.append("\nuses only ").append(n2).append(" funcs out of ").append(this.funcs.length);
        }
        return stringBuffer.toString();
    }

    private void checkArity(int n) throws ArityException {
        if (this.arity() != n) {
            throw new ArityException("Expected " + this.arity() + " arguments, got " + n);
        }
    }

    private double[] getStack() {
        double[] dArray = (double[])stacks.get();
        if (dArray == null) {
            dArray = new double[128];
            stacks.set(dArray);
        }
        return dArray;
    }

    public double eval() throws ArityException {
        return this.eval(NO_ARGS);
    }

    public double eval(double d) throws ArityException {
        this.checkArity(1);
        double[] dArray = this.getStack();
        dArray[0] = d;
        this.exec(dArray, 0);
        return dArray[0];
    }

    public double eval(double d, double d2) throws ArityException {
        this.checkArity(2);
        double[] dArray = this.getStack();
        dArray[0] = d;
        dArray[1] = d2;
        this.exec(dArray, 1);
        return dArray[0];
    }

    public double eval(double[] dArray) throws ArityException {
        this.checkArity(dArray.length);
        double[] dArray2 = this.getStack();
        if (dArray.length > 0) {
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        }
        this.exec(dArray2, dArray.length - 1);
        return dArray2[0];
    }

    void exec(double[] dArray, int n) {
        int n2;
        int n3 = this.execWithoutCheck(dArray, n);
        if (n3 != (n2 = n - this.arity + 1)) {
            throw new Error("stack pointer after exec: expected " + n2 + ", got " + n3);
        }
    }

    int execWithoutCheck(double[] dArray, int n) {
        byte[] byArray = this.code;
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        switch (this.arity) {
            case 5: {
                d = dArray[n--];
            }
            case 4: {
                d2 = dArray[n--];
            }
            case 3: {
                d3 = dArray[n--];
            }
            case 2: {
                d4 = dArray[n--];
            }
            case 1: {
                d5 = dArray[n--];
            }
        }
        int n5 = byArray.length;
        block57: for (int i = 0; i < n5; ++i) {
            switch (byArray[i]) {
                case 1: {
                    dArray[++n] = this.consts[n3++];
                    continue block57;
                }
                case 2: {
                    Function function = this.funcs[n4++];
                    if (function instanceof CompiledFunction) {
                        n = ((CompiledFunction)function).execWithoutCheck(dArray, n);
                        continue block57;
                    }
                    int n6 = function.arity();
                    n -= n6;
                    try {
                        double d6;
                        switch (n6) {
                            case 0: {
                                d6 = function.eval();
                                break;
                            }
                            case 1: {
                                d6 = function.eval(dArray[n + 1]);
                                break;
                            }
                            case 2: {
                                d6 = function.eval(dArray[n + 1], dArray[n + 2]);
                                break;
                            }
                            default: {
                                double[] dArray2 = new double[n6];
                                System.arraycopy(dArray, n + 1, dArray2, 0, n6);
                                d6 = function.eval(dArray2);
                            }
                        }
                        dArray[++n] = d6;
                        continue block57;
                    }
                    catch (ArityException arityException) {
                        throw new Error("" + arityException);
                    }
                }
                case 8: {
                    dArray[++n] = random.nextDouble();
                    continue block57;
                }
                case 3: {
                    int n7 = --n;
                    dArray[n7] = dArray[n7] + dArray[n + 1];
                    continue block57;
                }
                case 4: {
                    int n8 = --n;
                    dArray[n8] = dArray[n8] - dArray[n + 1];
                    continue block57;
                }
                case 5: {
                    int n9 = --n;
                    dArray[n9] = dArray[n9] * dArray[n + 1];
                    continue block57;
                }
                case 6: {
                    int n10 = --n;
                    dArray[n10] = dArray[n10] / dArray[n + 1];
                    continue block57;
                }
                case 7: {
                    int n11 = --n;
                    dArray[n11] = dArray[n11] % dArray[n + 1];
                    continue block57;
                }
                case 10: {
                    dArray[--n] = MoreMath.pow(dArray[n], dArray[n + 1]);
                    continue block57;
                }
                case 9: {
                    dArray[n] = -dArray[n];
                    continue block57;
                }
                case 11: {
                    dArray[n] = MoreMath.factorial(dArray[n]);
                    continue block57;
                }
                case 16: {
                    dArray[n] = Math.sin(dArray[n] * 1.0);
                    continue block57;
                }
                case 17: {
                    dArray[n] = Math.cos(dArray[n] * 1.0);
                    continue block57;
                }
                case 18: {
                    dArray[n] = Math.tan(dArray[n] * 1.0);
                    continue block57;
                }
                case 19: {
                    dArray[n] = MoreMath.asin(dArray[n]) / 1.0;
                    continue block57;
                }
                case 20: {
                    dArray[n] = MoreMath.acos(dArray[n]) / 1.0;
                    continue block57;
                }
                case 21: {
                    dArray[n] = MoreMath.atan(dArray[n]) / 1.0;
                    continue block57;
                }
                case 14: {
                    dArray[n] = MoreMath.exp(dArray[n]);
                    continue block57;
                }
                case 15: {
                    dArray[n] = MoreMath.log(dArray[n]);
                    continue block57;
                }
                case 12: {
                    dArray[n] = Math.sqrt(dArray[n]);
                    continue block57;
                }
                case 13: {
                    dArray[n] = MoreMath.cbrt(dArray[n]);
                    continue block57;
                }
                case 22: {
                    dArray[n] = MoreMath.sinh(dArray[n]);
                    continue block57;
                }
                case 23: {
                    dArray[n] = MoreMath.cosh(dArray[n]);
                    continue block57;
                }
                case 24: {
                    dArray[n] = MoreMath.tanh(dArray[n]);
                    continue block57;
                }
                case 25: {
                    dArray[n] = MoreMath.asinh(dArray[n]);
                    continue block57;
                }
                case 26: {
                    dArray[n] = MoreMath.acosh(dArray[n]);
                    continue block57;
                }
                case 27: {
                    dArray[n] = MoreMath.atanh(dArray[n]);
                    continue block57;
                }
                case 28: {
                    dArray[n] = Math.abs(dArray[n]);
                    continue block57;
                }
                case 29: {
                    dArray[n] = Math.floor(dArray[n]);
                    continue block57;
                }
                case 30: {
                    dArray[n] = Math.ceil(dArray[n]);
                    continue block57;
                }
                case 31: {
                    dArray[n] = dArray[n] > 0.0 ? 1.0 : (dArray[n] < 0.0 ? -1.0 : 0.0);
                    continue block57;
                }
                case 32: {
                    dArray[--n] = Math.min(dArray[n], dArray[n + 1]);
                    continue block57;
                }
                case 33: {
                    dArray[--n] = Math.min(dArray[n], dArray[n + 1]);
                    continue block57;
                }
                case 34: {
                    dArray[--n] = MoreMath.gcd(dArray[n], dArray[n + 1]);
                    continue block57;
                }
                case 35: {
                    dArray[--n] = MoreMath.comb(dArray[n], dArray[n + 1]);
                    continue block57;
                }
                case 36: {
                    dArray[--n] = MoreMath.perm(dArray[n], dArray[n + 1]);
                    continue block57;
                }
                case 37: {
                    dArray[++n] = d5;
                    continue block57;
                }
                case 38: {
                    dArray[++n] = d4;
                    continue block57;
                }
                case 39: {
                    dArray[++n] = d3;
                    continue block57;
                }
                case 40: {
                    dArray[++n] = d2;
                    continue block57;
                }
                case 41: {
                    dArray[++n] = d;
                    continue block57;
                }
                default: {
                    throw new Error("Unknown opcode " + byArray[i]);
                }
            }
        }
        return n;
    }
}

