/*
 * Decompiled with CFR 0.152.
 */
package SharpTools;

import SharpTools.CellPoint;

public class CellRange {
    CellPoint minCorner;
    CellPoint maxCorner;

    public CellRange(int[] rows, int[] cols) {
        int minRow = rows[0];
        int maxRow = rows[rows.length - 1];
        int minCol = cols[0];
        int maxCol = cols[cols.length - 1];
        this.minCorner = new CellPoint(minRow, minCol);
        this.maxCorner = new CellPoint(maxRow, maxCol);
    }

    public CellRange(int minRow, int maxRow, int minCol, int maxCol) {
        this.minCorner = new CellPoint(minRow, minCol);
        this.maxCorner = new CellPoint(maxRow, maxCol);
    }

    public CellRange(CellPoint ULHCorner, CellPoint LRHCorner) {
        this.minCorner = ULHCorner;
        this.maxCorner = LRHCorner;
    }

    public int getStartRow() {
        return this.minCorner.getRow();
    }

    public int getEndRow() {
        return this.maxCorner.getRow();
    }

    public int getStartCol() {
        return this.minCorner.getCol();
    }

    public int getEndCol() {
        return this.maxCorner.getCol();
    }

    public int getWidth() {
        return this.getEndCol() - this.getStartCol() + 1;
    }

    public int getHeight() {
        return this.getEndRow() - this.getStartRow() + 1;
    }

    public CellPoint getminCorner() {
        return this.minCorner;
    }

    public CellPoint getmaxCorner() {
        return this.maxCorner;
    }

    public String toString() {
        return this.minCorner.toString() + ':' + this.maxCorner.toString();
    }
}

