/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "keyboardui.h"
#include "ukcccommon.h"
using namespace ukcc;

KeyboardUi::KeyboardUi(QWidget *parent, Qt::WindowFlags f) : QWidget(parent, f)
{
    setAttribute(Qt::WA_DeleteOnClose);
    mVlayout = new QVBoxLayout(this);
    mVlayout->setContentsMargins(0, 0, 0, 0);
    mVlayout->setSpacing(8);
    initUI();
}

KeyboardUi::~KeyboardUi()
{

}

void KeyboardUi::initUI()
{
    mKeyboardFrame = new SettingGroup(this);
    mKeyboardSetTitleLabel = new TitleLabel(this);
    //~ contents_path /Keyboard/Keyboard Settings
    mKeyboardSetTitleLabel->setText(tr("Keyboard Settings"));
    mKeyboardSetTitleLabel->setContentsMargins(16, 0, 0, 0);

    setKeyRepeatFrame();
    setDelayFrame();
    setSpeedFrame();
    setInputTestFrame();
    setKeyTipsFrame();

    mInputTitleLabel = new TitleLabel(this);
    //~ contents_path /Keyboard/Input Method
    mInputTitleLabel->setText(tr("Input Method"));
    mInputTitleLabel->setContentsMargins(16, 0, 0, 0);
    setInputMethodFrame();

    /* add widget */
    mKeyboardFrame->insertWidget(0, mKeyRepeatFrame);
    mKeyboardFrame->insertWidget(1, mDelayFrame);
    mKeyboardFrame->insertWidget(2, mSpeedFrame);
    mKeyboardFrame->insertWidget(3, mInputTestFrame);
#ifdef YANGTZE
    mKeyboardFrame->insertWidget(4, mKeyTipsFrame);
#endif

    mVirtualKeyboardFrame = new SettingGroup(this);
    mVirtualKeyboardSetTitleLabel = new TitleLabel(this);
    //~ contents_path /Keyboard/Virtual Keyboard
    mVirtualKeyboardSetTitleLabel->setText(tr("Virtual Keyboard"));
    mVirtualKeyboardSetTitleLabel->setContentsMargins(16, 0, 0, 0);

    setShowIconOnDesktopFrame();
    setShowIconOnTrayFrame();
    setVirtualKeyboardSizeFrame();
    setTextSizeFrame();
    setAnimationFrame();
    setSoundEfectsFrame();

    mVirtualKeyboardFrame->insertWidget(0, mShowIconOnTrayFrame);
    mVirtualKeyboardFrame->insertWidget(1, mShowIconOnDesktopFrame);
    mVirtualKeyboardFrame->insertWidget(2, mVirtualKeyboardSizeFrame);
    mVirtualKeyboardFrame->insertWidget(3, mTextSizeFrame);
    mVirtualKeyboardFrame->insertWidget(4, mAnimationFrame);
    mVirtualKeyboardFrame->insertWidget(5, mSoundEfectsFrame);

    mVlayout->addWidget(mKeyboardSetTitleLabel);
    mVlayout->addWidget(mKeyboardFrame);
#ifndef YANGTZE
    mVlayout->addWidget(mKeyTipsFrame);
    mVlayout->addSpacing(40);
#endif

    mVlayout->addWidget(mVirtualKeyboardSetTitleLabel);
    mVlayout->addWidget(mVirtualKeyboardFrame);

#ifndef YANGTZE
    mVlayout->addSpacing(40);
#endif

    mVlayout->addWidget(mInputTitleLabel);
    mVlayout->addWidget(mInputMethodSetFrame);
    mVlayout->addWidget(mInputMethodSetBtn);
    mVlayout->addStretch();

    // 部分功能暂时隐藏，等虚拟键盘提供接口支持后显示
    mShowIconOnTrayFrame->setVisible(false);
    mTextSizeFrame->setVisible(false);
    mSoundEfectsFrame->setVisible(false);

#ifdef YANGTZE
    mVirtualKeyboardSetTitleLabel->setVisible(false);
    mVirtualKeyboardFrame->setVisible(false);
    mInputTitleLabel->setVisible(false);
    mInputMethodSetFrame->setVisible(false);
#else
    mInputMethodSetBtn->setVisible(false);
#endif
}

void KeyboardUi::setKeyRepeatFrame()
{
    /* Key Repeat */
    //~ contents_path /Keyboard/Key repeat
    mKeyRepeatFrame = new SwitchWidget(tr("Key repeat"), this, UkccFrame::None);
    mKeyRepeatFrame->setObjectName("Key repeat");
}

void KeyboardUi::setDelayFrame()
{
    /* delay */
    //~ contents_path /Keyboard/Delay
    mDelayFrame = new SliderWidget(tr("Delay"), false, this);
    mDelayFrame->slider()->setSliderType(KSliderType::StepSlider);
    mDelayFrame->setObjectName("Delay");
    mDelayFrame->setLeftText(tr("Short"));
    mDelayFrame->setRightText(tr("Long"));
    mDelayFrame->slider()->setMinimum(200);
    mDelayFrame->slider()->setMaximum(2100);
    mDelayFrame->slider()->setPageStep(20);
    mDelayFrame->slider()->setSingleStep(20);
    mDelayFrame->slider()->installEventFilter(this);
}

void KeyboardUi::setSpeedFrame()
{
    /* Speed */
    //~ contents_path /Keyboard/Speed
    mSpeedFrame = new SliderWidget(tr("Speed"), false, this);
    mSpeedFrame->setObjectName("Speed");
    mSpeedFrame->setLeftText(tr("Slow"));
    mSpeedFrame->setRightText(tr("Fast"));
    mSpeedFrame->slider()->setMinimum(10);
    mSpeedFrame->slider()->setMaximum(110);
    mSpeedFrame->slider()->setPageStep(1);
    mSpeedFrame->slider()->installEventFilter(this);
}

void KeyboardUi::setInputTestFrame()
{
    /* Input test */
    //~ contents_path /Keyboard/Input test
    mInputTestFrame = new LineEditWidget(tr("Input test"), this);

}

void KeyboardUi::setKeyTipsFrame()
{
    /* key tips */
    //~ contents_path /Keyboard/Key tips
    mKeyTipsFrame = new SwitchWidget(tr("Key tips"), this, UkccFrame::Around);
    mKeyTipsFrame->setObjectName("Key tips");
}

void KeyboardUi::setInputMethodFrame()
{
    /* Input method */
    mInputMethodSetBtn = new QPushButton(this);
    //~ contents_path /Keyboard/Input settings
    mInputMethodSetBtn->setText(tr("Input settings"));
    mInputMethodSetBtn->setObjectName("Input settings");
    mInputMethodSetBtn->setMinimumWidth(160);
    mInputMethodSetBtn->setMaximumWidth(180);

    //~ contents_path /Keyboard/Input Method
    mInputMethodSetFrame = new PushButtonWidget(tr("Input Method"), this, UkccFrame::Around);
    mInputMethodSetFrame->setButtonText(tr("Edit"));
    mInputMethodSetFrame->setObjectName("Input Method");
}

void KeyboardUi::setShowIconOnTrayFrame()
{
    //~ contents_path /Keyboard/Show icon on tray
    mShowIconOnTrayFrame = new SwitchWidget(tr("Show icon on tray"), this, UkccFrame::None);
    mShowIconOnTrayFrame->setObjectName("Show icon on tray");
}

void KeyboardUi::setShowIconOnDesktopFrame()
{
    //~ contents_path /Keyboard/Show icon on desktop
    mShowIconOnDesktopFrame = new SwitchWidget(tr("Show icon on desktop"), this, UkccFrame::None);
    mShowIconOnDesktopFrame->setObjectName("Show icon on desktop");
}

void KeyboardUi::setVirtualKeyboardSizeFrame()
{
    //~ contents_path /Keyboard/Keyboard Size
    mVirtualKeyboardSizeFrame = new SliderWidget(tr("Keyboard Size"), false, this);
    mVirtualKeyboardSizeFrame->setObjectName("Keyboard Size");
    mVirtualKeyboardSizeFrame->slider()->setRange(20,100);
}

void KeyboardUi::setTextSizeFrame()
{
    //~ contents_path /Keyboard/Text size
    mTextSizeFrame = new ComboxWidget(tr("Text size"), this);
    mTextSizeFrame->setObjectName("Text size");
    mTextSizeFrame->comboBox()->addItem(tr("Small"), SMALLTEXTSIZE);
    mTextSizeFrame->comboBox()->addItem(tr("Medium"), MEDIUMTEXTSIZE);
    mTextSizeFrame->comboBox()->addItem(tr("Large"), LARGETEXTSIZE);
}

void KeyboardUi::setAnimationFrame()
{
    //~ contents_path /Keyboard/Animation
    mAnimationFrame = new SwitchWidget(tr("Animation"), this, UkccFrame::None);
    mAnimationFrame->setObjectName("Animation");
}

void KeyboardUi::setSoundEfectsFrame()
{
    //~ contents_path /Keyboard/Input sound effect
    mSoundEfectsFrame = new SwitchWidget(tr("Input sound effect"), this, UkccFrame::None);
    mSoundEfectsFrame->setObjectName("Input sound effect");
}
