% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggally_statistic}
\alias{ggally_statistic}
\title{Generalized text display}
\usage{
ggally_statistic(
  data,
  mapping,
  text_fn,
  title,
  na.rm = NA,
  display_grid = FALSE,
  justify_labels = "right",
  justify_text = "left",
  sep = ": ",
  family = "mono",
  title_args = list(),
  group_args = list(),
  align_percent = 0.5,
  title_hjust = 0.5,
  group_hjust = 0.5
)
}
\arguments{
\item{data}{data set using}

\item{mapping}{aesthetics being used}

\item{text_fn}{function that takes in \code{x} and \code{y} and returns a text string}

\item{title}{title text to be displayed}

\item{na.rm}{logical value which determines if \code{NA} values are removed. If \code{TRUE}, no warning message will be displayed.}

\item{display_grid}{if \code{TRUE}, display aligned panel grid lines. If \code{FALSE} (default), display a thin panel border.}

\item{justify_labels}{\code{justify} argument supplied when \code{\link[base]{format}}ting the labels}

\item{justify_text}{\code{justify} argument supplied when \code{\link[base]{format}}ting the returned \code{text_fn(x, y)} values}

\item{sep}{separation value to be placed between the labels and text}

\item{family}{font family used when displaying all text.  This value will be set in \code{title_args} or \code{group_args} if no \code{family} value exists.  By using \code{"mono"}, groups will align with each other.}

\item{title_args}{arguments being supplied to the title's \code{\link[ggplot2]{geom_text}()}}

\item{group_args}{arguments being supplied to the split-by-color group's \code{\link[ggplot2]{geom_text}()}}

\item{align_percent}{relative align position of the text. When \code{title_hjust = 0.5} and \code{group_hjust = 0.5}, this should not be needed to be set.}

\item{title_hjust, group_hjust}{\code{hjust} sent to \code{\link[ggplot2]{geom_text}()} for the title and group values respectively. Any \code{hjust} value supplied in \code{title_args} or \code{group_args} will take precedence.}
}
\description{
Generalized text display
}
\seealso{
\code{\link{ggally_cor}}
}
