% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle_ard.R
\name{.detect_msgs}
\alias{.detect_msgs}
\title{Detect Columns with Non-Null Contents}
\usage{
.detect_msgs(x, ...)
}
\arguments{
\item{x}{(\code{data.frame})\cr
a data frame}

\item{...}{(\code{\link[rlang:dyn-dots]{dynamic-dots}})\cr
columns to search within}
}
\description{
Function looks for non-null contents in requested columns and notifies user
before removal. Specifically used for detecting messages.
}
\examples{
ard <- ard_summary(
  ADSL,
  by = ARM,
  variables = AGE,
  statistic = ~ list(
    mean = \(x) mean(x),
    mean_warning = \(x) {
      warning("warn1")
      warning("warn2")
      mean(x)
    },
    err_fn = \(x) stop("'tis an error")
  )
)

cards:::.detect_msgs(ard, "warning", "error")
}
\keyword{internal}
