//  OpenVPN 3 Linux client -- Next generation OpenVPN client
//
//  SPDX-License-Identifier: AGPL-3.0-only
//
//  Copyright (C) 2019-  OpenVPN Inc <sales@openvpn.net>
//  Copyright (C) 2019-  Lev Stipakov <lev@openvpn.net>
//  Copyright (C) 2019-  David Sommerseth <davids@openvpn.net>
//

/**
 * @file   netcfg-changetype.cpp
 *
 * @brief  Implements support functions needed by NetCfgChangeType
 */

#include "netcfg-changetype.hpp"


NetCfgChangeType operator|(const NetCfgChangeType &a, const NetCfgChangeType &b)
{
    return NetCfgChangeType(static_cast<std::uint32_t>(a) | static_cast<std::uint32_t>(b));
}
