;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2025 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; REQUIRES: regkeys
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=LS_enableLoadSplitting=1 --regkey=LS_ignoreSplitThreshold=1 --regkey=LS_minSplitSize_GRF=0 --regkey=LS_minSplitSize_E=0 %s | FileCheck %s --check-prefix=MINSPLIT
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=LS_enableLoadSplitting=1 --regkey=LS_ignoreSplitThreshold=1 --regkey=LS_minSplitSize_GRF=0 --regkey=LS_minSplitSize_E=8 %s | FileCheck %s --check-prefix=SPLIT8

declare spir_func void @fun_v4i32(<4 x i32>)
declare spir_func void @fun_v8i32(<8 x i32>)
declare spir_func void @fun_v16i32(<16 x i32>)

declare spir_func void @fun_v4fl(<4 x float>)
declare spir_func void @fun_v8fl(<8 x float>)
declare spir_func void @fun_v16fl(<16 x float>)

declare spir_func void @fun_v8i16(<8 x i16>)

declare spir_func <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64, i32, i32, i32, i32, i32, i32, i32, i32, i32, i1, i1, i32)
declare spir_func <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64, i32, i32, i32, i32, i32, i32, i32, i32, i32, i1, i1, i32)

define spir_kernel void @basic_shuffles_1(i64 %ptr) {
  ; This should pick elements:
  ; %pick1.1 : 8,9,10,11
  ; %pick1.2 : 0,1,2,3
  ; %pick1.3 : 4,5,6,7
  ; %pick1.4 : 12,13,14,15
; MINSPLIT-LABEL: @basic_shuffles_1(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 12, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @basic_shuffles_1(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i32> [[TMP1]], i64 0
; SPLIT8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i32> undef, i32 [[TMP2]], i64 0
; SPLIT8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i32> [[TMP1]], i64 1
; SPLIT8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i32> [[TMP3]], i32 [[TMP4]], i64 1
; SPLIT8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i32> [[TMP1]], i64 2
; SPLIT8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i32> [[TMP5]], i32 [[TMP6]], i64 2
; SPLIT8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i32> [[TMP1]], i64 3
; SPLIT8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i32> [[TMP7]], i32 [[TMP8]], i64 3
; SPLIT8-NEXT:    [[TMP10:%.*]] = extractelement <8 x i32> [[TMP1]], i64 4
; SPLIT8-NEXT:    [[TMP11:%.*]] = insertelement <4 x i32> undef, i32 [[TMP10]], i64 0
; SPLIT8-NEXT:    [[TMP12:%.*]] = extractelement <8 x i32> [[TMP1]], i64 5
; SPLIT8-NEXT:    [[TMP13:%.*]] = insertelement <4 x i32> [[TMP11]], i32 [[TMP12]], i64 1
; SPLIT8-NEXT:    [[TMP14:%.*]] = extractelement <8 x i32> [[TMP1]], i64 6
; SPLIT8-NEXT:    [[TMP15:%.*]] = insertelement <4 x i32> [[TMP13]], i32 [[TMP14]], i64 2
; SPLIT8-NEXT:    [[TMP16:%.*]] = extractelement <8 x i32> [[TMP1]], i64 7
; SPLIT8-NEXT:    [[TMP17:%.*]] = insertelement <4 x i32> [[TMP15]], i32 [[TMP16]], i64 3
; SPLIT8-NEXT:    [[TMP18:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP19:%.*]] = extractelement <8 x i32> [[TMP18]], i64 0
; SPLIT8-NEXT:    [[TMP20:%.*]] = insertelement <4 x i32> undef, i32 [[TMP19]], i64 0
; SPLIT8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i32> [[TMP18]], i64 1
; SPLIT8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i32> [[TMP20]], i32 [[TMP21]], i64 1
; SPLIT8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i32> [[TMP18]], i64 2
; SPLIT8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i32> [[TMP22]], i32 [[TMP23]], i64 2
; SPLIT8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i32> [[TMP18]], i64 3
; SPLIT8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i32> [[TMP24]], i32 [[TMP25]], i64 3
; SPLIT8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i32> [[TMP18]], i64 4
; SPLIT8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i32> undef, i32 [[TMP27]], i64 0
; SPLIT8-NEXT:    [[TMP29:%.*]] = extractelement <8 x i32> [[TMP18]], i64 5
; SPLIT8-NEXT:    [[TMP30:%.*]] = insertelement <4 x i32> [[TMP28]], i32 [[TMP29]], i64 1
; SPLIT8-NEXT:    [[TMP31:%.*]] = extractelement <8 x i32> [[TMP18]], i64 6
; SPLIT8-NEXT:    [[TMP32:%.*]] = insertelement <4 x i32> [[TMP30]], i32 [[TMP31]], i64 2
; SPLIT8-NEXT:    [[TMP33:%.*]] = extractelement <8 x i32> [[TMP18]], i64 7
; SPLIT8-NEXT:    [[TMP34:%.*]] = insertelement <4 x i32> [[TMP32]], i32 [[TMP33]], i64 3
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP26]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP9]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP17]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP34]])
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick1.1 = shufflevector <16 x i32> undef, <16 x i32> %vec1, <4 x i32> <i32 24, i32 25, i32 26, i32 27>
  %pick1.2 = shufflevector <16 x i32> <i32 undef, i32 1, i32 poison, i32 -1, i32 undef, i32 1, i32 poison, i32 -1, i32 undef, i32 1, i32 poison, i32 -1, i32 undef, i32 1, i32 poison, i32 -1>, <16 x i32> %vec1, <4 x i32> <i32 16, i32 17, i32 18, i32 19>
  %pick1.3 = shufflevector <16 x i32> poison, <16 x i32> %vec1, <4 x i32> <i32 20, i32 21, i32 22, i32 23>
  %pick1.4 = shufflevector <16 x i32> %vec1, <16 x i32> zeroinitializer, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  call void @fun_v4i32(<4 x i32> %pick1.1)
  call void @fun_v4i32(<4 x i32> %pick1.2)
  call void @fun_v4i32(<4 x i32> %pick1.3)
  call void @fun_v4i32(<4 x i32> %pick1.4)
  ret void
}

define spir_kernel void @basic_shuffles_2(i64 %ptr) {
  ; This should pick elements:
  ; %pick1.1 : 0,1,2,3
  ; %pick1.2 : 4,5,6,7
; MINSPLIT-LABEL: @basic_shuffles_2(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @basic_shuffles_2(
; SPLIT8-NEXT:    [[VEC1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK1_1:%.*]] = shufflevector <8 x i32> [[VEC1]], <8 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
; SPLIT8-NEXT:    [[PICK1_2:%.*]] = shufflevector <8 x i32> [[VEC1]], <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; SPLIT8-NEXT:    [[PICK1_1_1:%.*]] = shufflevector <4 x i32> [[PICK1_1]], <4 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_1_1]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_2]])
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
  %pick1.1 = shufflevector <8 x i32> %vec1, <8 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  %pick1.2 = shufflevector <8 x i32> %vec1, <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick1.1.1 = shufflevector <4 x i32> %pick1.1, <4 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  call void @fun_v4i32(<4 x i32> %pick1.1.1)
  call void @fun_v4i32(<4 x i32> %pick1.2)
  ret void
}

define spir_kernel void @basic_shuffles_3(i64 %ptr) {
; MINSPLIT-LABEL: @basic_shuffles_3(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 12, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @basic_shuffles_3(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i32> [[TMP1]], i64 0
; SPLIT8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i32> undef, i32 [[TMP2]], i64 0
; SPLIT8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i32> [[TMP1]], i64 1
; SPLIT8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i32> [[TMP3]], i32 [[TMP4]], i64 1
; SPLIT8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i32> [[TMP1]], i64 2
; SPLIT8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i32> [[TMP5]], i32 [[TMP6]], i64 2
; SPLIT8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i32> [[TMP1]], i64 3
; SPLIT8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i32> [[TMP7]], i32 [[TMP8]], i64 3
; SPLIT8-NEXT:    [[TMP10:%.*]] = extractelement <8 x i32> [[TMP1]], i64 4
; SPLIT8-NEXT:    [[TMP11:%.*]] = insertelement <4 x i32> undef, i32 [[TMP10]], i64 0
; SPLIT8-NEXT:    [[TMP12:%.*]] = extractelement <8 x i32> [[TMP1]], i64 5
; SPLIT8-NEXT:    [[TMP13:%.*]] = insertelement <4 x i32> [[TMP11]], i32 [[TMP12]], i64 1
; SPLIT8-NEXT:    [[TMP14:%.*]] = extractelement <8 x i32> [[TMP1]], i64 6
; SPLIT8-NEXT:    [[TMP15:%.*]] = insertelement <4 x i32> [[TMP13]], i32 [[TMP14]], i64 2
; SPLIT8-NEXT:    [[TMP16:%.*]] = extractelement <8 x i32> [[TMP1]], i64 7
; SPLIT8-NEXT:    [[TMP17:%.*]] = insertelement <4 x i32> [[TMP15]], i32 [[TMP16]], i64 3
; SPLIT8-NEXT:    [[TMP18:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP19:%.*]] = extractelement <8 x i32> [[TMP18]], i64 0
; SPLIT8-NEXT:    [[TMP20:%.*]] = insertelement <4 x i32> undef, i32 [[TMP19]], i64 0
; SPLIT8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i32> [[TMP18]], i64 1
; SPLIT8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i32> [[TMP20]], i32 [[TMP21]], i64 1
; SPLIT8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i32> [[TMP18]], i64 2
; SPLIT8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i32> [[TMP22]], i32 [[TMP23]], i64 2
; SPLIT8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i32> [[TMP18]], i64 3
; SPLIT8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i32> [[TMP24]], i32 [[TMP25]], i64 3
; SPLIT8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i32> [[TMP18]], i64 4
; SPLIT8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i32> undef, i32 [[TMP27]], i64 0
; SPLIT8-NEXT:    [[TMP29:%.*]] = extractelement <8 x i32> [[TMP18]], i64 5
; SPLIT8-NEXT:    [[TMP30:%.*]] = insertelement <4 x i32> [[TMP28]], i32 [[TMP29]], i64 1
; SPLIT8-NEXT:    [[TMP31:%.*]] = extractelement <8 x i32> [[TMP18]], i64 6
; SPLIT8-NEXT:    [[TMP32:%.*]] = insertelement <4 x i32> [[TMP30]], i32 [[TMP31]], i64 2
; SPLIT8-NEXT:    [[TMP33:%.*]] = extractelement <8 x i32> [[TMP18]], i64 7
; SPLIT8-NEXT:    [[TMP34:%.*]] = insertelement <4 x i32> [[TMP32]], i32 [[TMP33]], i64 3
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP9]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP17]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP26]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP34]])
; SPLIT8-NEXT:    ret void
;
  %vec1 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick1 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 1, i32 3, i32 5, i32 7>
  %pick2 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <8 x i32> <i32 8, i32 10, i32 12, i32 14, i32 9, i32 11, i32 13, i32 15>
  %pick1.1 = shufflevector <8 x i32> %pick1, <8 x i32> undef, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %pick1.2 = shufflevector <8 x i32> %pick1, <8 x i32> undef, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %pick2.1 = shufflevector <8 x i32> %pick2, <8 x i32> undef, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %pick2.2 = shufflevector <8 x i32> %pick2, <8 x i32> undef, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  call void @fun_v4i32(<4 x i32> %pick1.1)
  call void @fun_v4i32(<4 x i32> %pick1.2)
  call void @fun_v4i32(<4 x i32> %pick2.1)
  call void @fun_v4i32(<4 x i32> %pick2.2)
  ret void
}

define spir_kernel void @trees_success_1(i64 %ptr) {
  ;
  ; INPUT:
  ;
  ; load -> bitcast to float -> pick(0,1,2,3) -> call[1]
  ;                  \
  ;                   \-------> pick(4,5,6,7) -> bitcast to i32 -> call[2]
  ;                                     \
  ;                                      \-----> call[3]
  ;
  ; OUTPUT:
  ;
  ; load(0,1,2,3) --> bitcast to float -> call[1]
  ;
  ; load(4,5,6,7) --> call[2]
  ;        \
  ;         \-------> bitcast to float -> call[3]
  ;
; MINSPLIT-LABEL: @trees_success_1(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[TMP1]] to <4 x float>
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = bitcast <4 x i32> [[TMP3]] to <4 x float>
; MINSPLIT-NEXT:    call void @fun_v4fl(<4 x float> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4fl(<4 x float> [[TMP4]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP3]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @trees_success_1(
; SPLIT8-NEXT:    [[VEC2:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[VEC2_FL:%.*]] = bitcast <8 x i32> [[VEC2]] to <8 x float>
; SPLIT8-NEXT:    [[PICK2_1_FL:%.*]] = shufflevector <8 x float> [[VEC2_FL]], <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; SPLIT8-NEXT:    [[PICK2_2_FL:%.*]] = shufflevector <8 x float> [[VEC2_FL]], <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; SPLIT8-NEXT:    [[PICK2_2_I32:%.*]] = bitcast <4 x float> [[PICK2_2_FL]] to <4 x i32>
; SPLIT8-NEXT:    call void @fun_v4fl(<4 x float> [[PICK2_1_FL]])
; SPLIT8-NEXT:    call void @fun_v4fl(<4 x float> [[PICK2_2_FL]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK2_2_I32]])
; SPLIT8-NEXT:    ret void
;
  %vec2 = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
  %vec2.fl = bitcast <8 x i32> %vec2 to <8 x float>
  %pick2.1.fl = shufflevector <8 x float> %vec2.fl, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick2.2.fl = shufflevector <8 x float> %vec2.fl, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick2.2.i32 = bitcast <4 x float> %pick2.2.fl to <4 x i32>
  call void @fun_v4fl(<4 x float> %pick2.1.fl)
  call void @fun_v4fl(<4 x float> %pick2.2.fl)
  call void @fun_v4i32(<4 x i32> %pick2.2.i32)
  ret void
}

define spir_kernel void @trees_success_2(i64 %ptr) {
  ;
  ; INPUT:
  ;
  ; load ---> pick(0-7) --> pick(0,1,2,3) -> call[1]
  ;   \           \
  ;    \           \------> pick(4,5,6,7) -> call[2]
  ;     \
  ;      \--> pick(8-15) -> pick(0,2,4,6) -> call[3]
  ;               \
  ;                \------> pick(1,3,5,7) -> call[4]
  ;
  ; OUTPUT:
  ;
  ; load(0,1,2,3) ----> call[1]
  ; load(4,5,6,7) ----> call[2]
  ; load(8,9,10,11) -> call[3]
  ; load(12,13,14,15) -> call[4]
  ;
; MINSPLIT-LABEL: @trees_success_2(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 12, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @trees_success_2(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i32> [[TMP1]], i64 0
; SPLIT8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i32> undef, i32 [[TMP2]], i64 0
; SPLIT8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i32> [[TMP1]], i64 1
; SPLIT8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i32> [[TMP3]], i32 [[TMP4]], i64 1
; SPLIT8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i32> [[TMP1]], i64 2
; SPLIT8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i32> [[TMP5]], i32 [[TMP6]], i64 2
; SPLIT8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i32> [[TMP1]], i64 3
; SPLIT8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i32> [[TMP7]], i32 [[TMP8]], i64 3
; SPLIT8-NEXT:    [[TMP10:%.*]] = extractelement <8 x i32> [[TMP1]], i64 4
; SPLIT8-NEXT:    [[TMP11:%.*]] = insertelement <4 x i32> undef, i32 [[TMP10]], i64 0
; SPLIT8-NEXT:    [[TMP12:%.*]] = extractelement <8 x i32> [[TMP1]], i64 5
; SPLIT8-NEXT:    [[TMP13:%.*]] = insertelement <4 x i32> [[TMP11]], i32 [[TMP12]], i64 1
; SPLIT8-NEXT:    [[TMP14:%.*]] = extractelement <8 x i32> [[TMP1]], i64 6
; SPLIT8-NEXT:    [[TMP15:%.*]] = insertelement <4 x i32> [[TMP13]], i32 [[TMP14]], i64 2
; SPLIT8-NEXT:    [[TMP16:%.*]] = extractelement <8 x i32> [[TMP1]], i64 7
; SPLIT8-NEXT:    [[TMP17:%.*]] = insertelement <4 x i32> [[TMP15]], i32 [[TMP16]], i64 3
; SPLIT8-NEXT:    [[TMP18:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP19:%.*]] = extractelement <8 x i32> [[TMP18]], i64 0
; SPLIT8-NEXT:    [[TMP20:%.*]] = insertelement <4 x i32> undef, i32 [[TMP19]], i64 0
; SPLIT8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i32> [[TMP18]], i64 1
; SPLIT8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i32> [[TMP20]], i32 [[TMP21]], i64 1
; SPLIT8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i32> [[TMP18]], i64 2
; SPLIT8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i32> [[TMP22]], i32 [[TMP23]], i64 2
; SPLIT8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i32> [[TMP18]], i64 3
; SPLIT8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i32> [[TMP24]], i32 [[TMP25]], i64 3
; SPLIT8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i32> [[TMP18]], i64 4
; SPLIT8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i32> undef, i32 [[TMP27]], i64 0
; SPLIT8-NEXT:    [[TMP29:%.*]] = extractelement <8 x i32> [[TMP18]], i64 5
; SPLIT8-NEXT:    [[TMP30:%.*]] = insertelement <4 x i32> [[TMP28]], i32 [[TMP29]], i64 1
; SPLIT8-NEXT:    [[TMP31:%.*]] = extractelement <8 x i32> [[TMP18]], i64 6
; SPLIT8-NEXT:    [[TMP32:%.*]] = insertelement <4 x i32> [[TMP30]], i32 [[TMP31]], i64 2
; SPLIT8-NEXT:    [[TMP33:%.*]] = extractelement <8 x i32> [[TMP18]], i64 7
; SPLIT8-NEXT:    [[TMP34:%.*]] = insertelement <4 x i32> [[TMP32]], i32 [[TMP33]], i64 3
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP9]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP17]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP26]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP34]])
; SPLIT8-NEXT:    ret void
;
  %vec3 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick3.1.i32 = shufflevector <16 x i32> %vec3, <16 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %pick3.2.i32 = shufflevector <16 x i32> %vec3, <16 x i32> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %pick3.1.1.i32 = shufflevector <8 x i32> %pick3.1.i32, <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick3.1.2.i32 = shufflevector <8 x i32> %pick3.1.i32, <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick3.2.1.i32 = shufflevector <8 x i32> %pick3.2.i32, <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick3.2.2.i32 = shufflevector <8 x i32> %pick3.2.i32, <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  call void @fun_v4i32(<4 x i32> %pick3.1.1.i32)
  call void @fun_v4i32(<4 x i32> %pick3.1.2.i32)
  call void @fun_v4i32(<4 x i32> %pick3.2.1.i32)
  call void @fun_v4i32(<4 x i32> %pick3.2.2.i32)
  ret void
}

define spir_kernel void @trees_success_3(i64 %ptr) {
  ;
  ; INPUT:
  ;
  ; load(0-15) -> bitcast to float -> pick(8-15) -> pick(4,5,6,7) --> call[2]
  ;                      \                 \
  ;                       \                 \------> pick(0,1,2,3) --> call[4]
  ;                        \                               \
  ;                         \                               \---> bitcast to i32 -> call[3]
  ;                          \
  ;                           \------> pick(0,1,2,3) ----------------> call[1]
  ;                            \
  ;                             \----> pick(4,5,6,7) ----------------> call[5]
  ;
  ; OUTPUT:
  ;
  ; load(12,13,14,15) -> bitcast to float -> call[2]
  ;
  ; load(8,9,10,11)   -> bitcast to float -> call[4]
  ;         \
  ;          \-----------------------------> call[3]
  ;
  ; load(0,1,2,3) -----> bitcast to float -> call[1]
  ;
  ; load(4,5,6,7) -----> bitcast to float -> call[5]
  ;
; MINSPLIT-LABEL: @trees_success_3(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = bitcast <4 x i32> [[TMP1]] to <4 x float>
; MINSPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP4:%.*]] = bitcast <4 x i32> [[TMP3]] to <4 x float>
; MINSPLIT-NEXT:    [[TMP5:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP6:%.*]] = bitcast <4 x i32> [[TMP5]] to <4 x float>
; MINSPLIT-NEXT:    [[TMP7:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 12, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP8:%.*]] = bitcast <4 x i32> [[TMP7]] to <4 x float>
; MINSPLIT-NEXT:    call void @fun_v4fl(<4 x float> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4fl(<4 x float> [[TMP8]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP5]])
; MINSPLIT-NEXT:    call void @fun_v4fl(<4 x float> [[TMP6]])
; MINSPLIT-NEXT:    call void @fun_v4fl(<4 x float> [[TMP4]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @trees_success_3(
; SPLIT8-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i32> [[TMP1]], i64 0
; SPLIT8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i32> undef, i32 [[TMP2]], i64 0
; SPLIT8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i32> [[TMP1]], i64 1
; SPLIT8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i32> [[TMP3]], i32 [[TMP4]], i64 1
; SPLIT8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i32> [[TMP1]], i64 2
; SPLIT8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i32> [[TMP5]], i32 [[TMP6]], i64 2
; SPLIT8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i32> [[TMP1]], i64 3
; SPLIT8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i32> [[TMP7]], i32 [[TMP8]], i64 3
; SPLIT8-NEXT:    [[TMP10:%.*]] = bitcast <4 x i32> [[TMP9]] to <4 x float>
; SPLIT8-NEXT:    [[TMP11:%.*]] = extractelement <8 x i32> [[TMP1]], i64 4
; SPLIT8-NEXT:    [[TMP12:%.*]] = insertelement <4 x i32> undef, i32 [[TMP11]], i64 0
; SPLIT8-NEXT:    [[TMP13:%.*]] = extractelement <8 x i32> [[TMP1]], i64 5
; SPLIT8-NEXT:    [[TMP14:%.*]] = insertelement <4 x i32> [[TMP12]], i32 [[TMP13]], i64 1
; SPLIT8-NEXT:    [[TMP15:%.*]] = extractelement <8 x i32> [[TMP1]], i64 6
; SPLIT8-NEXT:    [[TMP16:%.*]] = insertelement <4 x i32> [[TMP14]], i32 [[TMP15]], i64 2
; SPLIT8-NEXT:    [[TMP17:%.*]] = extractelement <8 x i32> [[TMP1]], i64 7
; SPLIT8-NEXT:    [[TMP18:%.*]] = insertelement <4 x i32> [[TMP16]], i32 [[TMP17]], i64 3
; SPLIT8-NEXT:    [[TMP19:%.*]] = bitcast <4 x i32> [[TMP18]] to <4 x float>
; SPLIT8-NEXT:    [[TMP20:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i32> [[TMP20]], i64 4
; SPLIT8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i32> undef, i32 [[TMP21]], i64 0
; SPLIT8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i32> [[TMP20]], i64 5
; SPLIT8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i32> [[TMP22]], i32 [[TMP23]], i64 1
; SPLIT8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i32> [[TMP20]], i64 6
; SPLIT8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i32> [[TMP24]], i32 [[TMP25]], i64 2
; SPLIT8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i32> [[TMP20]], i64 7
; SPLIT8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i32> [[TMP26]], i32 [[TMP27]], i64 3
; SPLIT8-NEXT:    [[TMP29:%.*]] = bitcast <4 x i32> [[TMP28]] to <4 x float>
; SPLIT8-NEXT:    [[TMP30:%.*]] = extractelement <8 x i32> [[TMP20]], i64 0
; SPLIT8-NEXT:    [[TMP31:%.*]] = insertelement <4 x i32> undef, i32 [[TMP30]], i64 0
; SPLIT8-NEXT:    [[TMP32:%.*]] = extractelement <8 x i32> [[TMP20]], i64 1
; SPLIT8-NEXT:    [[TMP33:%.*]] = insertelement <4 x i32> [[TMP31]], i32 [[TMP32]], i64 1
; SPLIT8-NEXT:    [[TMP34:%.*]] = extractelement <8 x i32> [[TMP20]], i64 2
; SPLIT8-NEXT:    [[TMP35:%.*]] = insertelement <4 x i32> [[TMP33]], i32 [[TMP34]], i64 2
; SPLIT8-NEXT:    [[TMP36:%.*]] = extractelement <8 x i32> [[TMP20]], i64 3
; SPLIT8-NEXT:    [[TMP37:%.*]] = insertelement <4 x i32> [[TMP35]], i32 [[TMP36]], i64 3
; SPLIT8-NEXT:    [[TMP38:%.*]] = bitcast <4 x i32> [[TMP37]] to <4 x float>
; SPLIT8-NEXT:    call void @fun_v4fl(<4 x float> [[TMP10]])
; SPLIT8-NEXT:    call void @fun_v4fl(<4 x float> [[TMP29]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP37]])
; SPLIT8-NEXT:    call void @fun_v4fl(<4 x float> [[TMP38]])
; SPLIT8-NEXT:    call void @fun_v4fl(<4 x float> [[TMP19]])
; SPLIT8-NEXT:    ret void
;
  %vec4 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %vec4.fl = bitcast <16 x i32> %vec4 to <16 x float>
  %pick4.1.fl = shufflevector <16 x float> %vec4.fl, <16 x float> undef, <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %pick4.2.fl = shufflevector <16 x float> %vec4.fl, <16 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick4.3.fl = shufflevector <16 x float> %vec4.fl, <16 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick4.1.1.fl = shufflevector <8 x float> %pick4.1.fl, <8 x float> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick4.1.2.fl = shufflevector <8 x float> %pick4.1.fl, <8 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick4.1.2.i32 = bitcast <4 x float> %pick4.1.2.fl to <4 x i32>
  call void @fun_v4fl(<4 x float> %pick4.2.fl)
  call void @fun_v4fl(<4 x float> %pick4.1.1.fl)
  call void @fun_v4i32(<4 x i32> %pick4.1.2.i32)
  call void @fun_v4fl(<4 x float> %pick4.1.2.fl)
  call void @fun_v4fl(<4 x float> %pick4.3.fl)
  ret void
}

define spir_kernel void @trees_success_4(i64 %ptr) {
  ;
  ; INPUT:
  ;
  ; load ----> pick(4,5,6,7) -> bitcast to float -> call[1]
  ;   \               \               \
  ;    \               \               \----------> call[2]
  ;     \               \
  ;      \               \------------------------> call[3]
  ;       \
  ;        \--------------> pick(0,1,2,3) -> call[6]
  ;         \
  ;          \-> pick(2-7) -> bitcast to float -> pick(2,3,4,5) -> bitcast to i32 -> call[5]
  ;                                                      \
  ;                                                       \------> call[4]
  ;
  ; OUTPUT:
  ;
  ; load(0,1,2,3) -> call[6]
  ;
  ; load(4,5,6,7) -> bitcast to float -> call[1]
  ;        \                \----------> call[2]
  ;         \                \---------> call[4]
  ;          \
  ;           \------------------------> call[3]
  ;            \-----------------------> call[5]
  ;
; MINSPLIT-LABEL: @trees_success_4(
; MINSPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; MINSPLIT-NEXT:    [[TMP3:%.*]] = bitcast <4 x i32> [[TMP2]] to <4 x float>
; MINSPLIT-NEXT:    call void @fun_v4fl(<4 x float> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4fl(<4 x float> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4fl(<4 x float> [[TMP3]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; MINSPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; MINSPLIT-NEXT:    ret void
;
; SPLIT8-LABEL: @trees_success_4(
; SPLIT8-NEXT:    [[VEC5:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; SPLIT8-NEXT:    [[PICK0:%.*]] = shufflevector <8 x i32> [[VEC5]], <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; SPLIT8-NEXT:    [[PICK5_1_I32:%.*]] = shufflevector <8 x i32> [[VEC5]], <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; SPLIT8-NEXT:    [[PICK5_2_I32:%.*]] = shufflevector <8 x i32> [[VEC5]], <8 x i32> undef, <8 x i32> <i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 7, i32 7>
; SPLIT8-NEXT:    [[PICK5_2_FL:%.*]] = bitcast <8 x i32> [[PICK5_2_I32]] to <8 x float>
; SPLIT8-NEXT:    [[PICK5_2_1_FL:%.*]] = shufflevector <8 x float> [[PICK5_2_FL]], <8 x float> undef, <4 x i32> <i32 2, i32 3, i32 4, i32 5>
; SPLIT8-NEXT:    [[PICK5_2_1_I32:%.*]] = bitcast <4 x float> [[PICK5_2_1_FL]] to <4 x i32>
; SPLIT8-NEXT:    [[PICK5_1_FL:%.*]] = bitcast <4 x i32> [[PICK5_1_I32]] to <4 x float>
; SPLIT8-NEXT:    call void @fun_v4fl(<4 x float> [[PICK5_1_FL]])
; SPLIT8-NEXT:    call void @fun_v4fl(<4 x float> [[PICK5_1_FL]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK5_1_I32]])
; SPLIT8-NEXT:    call void @fun_v4fl(<4 x float> [[PICK5_2_1_FL]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK5_2_1_I32]])
; SPLIT8-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK0]])
; SPLIT8-NEXT:    ret void
;
  %vec5 = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
  %pick0 = shufflevector <8 x i32> %vec5, <8 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick5.1.i32 = shufflevector <8 x i32> %vec5, <8 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick5.2.i32 = shufflevector <8 x i32> %vec5, <8 x i32> undef, <8 x i32> <i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 7, i32 7>
  %pick5.2.fl = bitcast <8 x i32> %pick5.2.i32 to <8 x float>
  %pick5.2.1.fl = shufflevector <8 x float> %pick5.2.fl, <8 x float> undef, <4 x i32> <i32 2, i32 3, i32 4, i32 5>
  %pick5.2.1.i32 = bitcast <4 x float> %pick5.2.1.fl to <4 x i32>
  %pick5.1.fl = bitcast <4 x i32> %pick5.1.i32 to <4 x float>
  call void @fun_v4fl(<4 x float> %pick5.1.fl)
  call void @fun_v4fl(<4 x float> %pick5.1.fl)
  call void @fun_v4i32(<4 x i32> %pick5.1.i32)
  call void @fun_v4fl(<4 x float> %pick5.2.1.fl)
  call void @fun_v4i32(<4 x i32> %pick5.2.1.i32)
  call void @fun_v4i32(<4 x i32> %pick0)
  ret void
}
