/* SPDX-License-Identifier: MIT
 * Copyright 2023 Advanced Micro Devices, Inc.
 * Copyright 2014 Advanced Micro Devices, Inc.
 */

#ifndef _AMD_MMD_VCE_IB_H_
#define _AMD_MMD_VCE_IB_H_

static const uint32_t vce_session[] = {
	0x0000000c,
	0x00000001,
	0x400c0001,
};

static uint32_t vce_taskinfo[] = {
	0x00000020,
	0x00000002,
	0xffffffff,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
};

static const uint32_t vce_create[] = {
	0x00000030,
	0x01000001,
	0x00000000,
	0x00000042,
	0x0000002a,
	0x00000000,
	0x000000a0,
	0x00000080,
	0x000000a0,
	0x000000a0,
	0x00000010,
	0x00000201,
};

static const uint32_t vce_rate_ctrl[] = {
	0x00000070,
	0x04000005,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x0000001c,
	0x0000001c,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000033,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
};

static const uint32_t vce_config_ext[] = {
	0x0000000c,
	0x04000001,
	0x00000003,
};

static const uint32_t vce_motion_est[] = {
	0x00000068,
	0x04000007,
	0x00000001,
	0x00000001,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000010,
	0x00000010,
	0x00000010,
	0x00000010,
	0x00000000,
	0x00000000,
	0x00000000,
	0x000000fe,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000001,
	0x00000001,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
};

static const uint32_t vce_rdo[] = {
	0x0000004c,
	0x04000008,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
};

static const uint32_t vce_pic_ctrl[] = {
	0x00000074,
	0x04000002,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000aa0,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000040,
	0x00000000,
	0x00000000,
	0x00000001,
	0x00000002,
	0x00000001,
	0x00000001,
	0x00000000,
	0x00000000,
};

static const uint32_t vce_feedback[] = {
	0x00000014,
	0x05000005,
	0x00000000,
	0xffffffff,
	0x00000001,
};

static const uint32_t vce_context_buffer[] = {
	0x00000010,
	0x05000001,
	0x00000000,
	0xffffffff,
};

static const uint32_t vce_bs_buffer[] = {
	0x00000014,
	0x05000004,
	0x00000000,
	0xffffffff,
	0x00154000,
};

static const uint32_t vce_aux_buffer[] = {
	0x00000048,
	0x05000002,
	0x0000f000,
	0x00016800,
	0x0001e000,
	0x00025800,
	0x0002d000,
	0x00034800,
	0x0003c000,
	0x00043800,
	0x00007800,
	0x00007800,
	0x00007800,
	0x00007800,
	0x00007800,
	0x00007800,
	0x00007800,
	0x00007800,
};

static uint32_t vce_encode[] = {
	0x00000160,
	0x03000001,
	0x00000011,
	0x00000000,
	0x00154000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0xffffffff,
	0x00000000,
	0xffffffff,
	0x00000080,
	0x000000a0,
	0x000000a0,
	0x00010000,
	0x00000000,
	0x00000003,
	0x00000001,
	0x00000000,
	0x00000000,
	0x00000001,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0xffffffff,
	0xffffffff,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0xffffffff,
	0xffffffff,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0xffffffff,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
};

static const uint32_t vce_destroy[] = {
	0x00000008,
	0x02000001,
};

static const uint32_t vce_mv_buffer[] = {
	0x00000038,
	0x0500000d,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
};
#endif /*_AMD_MMD_VCE_IB_H_*/
