ITK Code of Conduct Reporting Guidelines
========================================

Instances of abusive, harassing, or otherwise unacceptable behavior must be
reported.

If you believe anyone is in danger, please notify appropriate law enforcement
right away. If you believe that legal action should be taken, do so.

If you believe you are experiencing unacceptable behavior that will not be
tolerated as outlined above, or you have witnessed a breach to this Code of
Conduct, please email one of the members of the [Insight Software Consortium
Board Members](https://www.insightsoftwareconsortium.org/board.html). The contacted ISC Board Member will appropriately forward
the report to the Code of Conduct Committee. For inperson ITK event or
activities, please also notify the designated contact point. After receiving a
concise description of your situation, the Committee members will review and
determine next steps. In addition to conducting any investigation, they can
provide a range of resources, from a private consultation to other community
resources. They will involve other colleagues only as needed to appropriately
address each situation.

If you experience behavior outside of ITK communities, in person or online,
that makes participation in ITK not a safe and positive community experience
for all, please proceed as described above. While these guidelines are
specifically aimed at ITK's work and community, we recognize that it is
possible for actions taken outside of ITK's online or inperson spaces to have a
deep impact on community health (e.g. posting aimed at an ITK community member
in a non-ITK forum as clear grounds for removal from the ITK community). This
is an active topic in the diversity and inclusion realm. The delineation of
appropriate boundaries may vary.

For clearly intentional breaches, report those to the ITK Code of Conduct
Committee (see below). If you are unsure whether the incident is a violation,
or whether the space where it happened is covered by this Code of Conduct, we
encourage you to still report it. We would much rather have a few extra reports
where we decide to take no action, rather than miss a report of an actual
violation. We do not look negatively on you if we find the incident is not a
violation. And knowing about incidents that are not violations, or happen
outside our spaces, can also help us to improve the Code of Conduct or the
processes surrounding it.

For possibly unintentional breaches, you may reply to the person and point out
this Code of Conduct (either in public or in private, whatever is most
appropriate). If you would prefer not to do that, please feel free to report to
the Committee directly, or ask the Committee for advice.

In your report please include:

  * Your contact information (so we can get in touch with you if we need to
  follow up): given name, family name, email address, and phone number, if
  necessary.
  * Names (real, nicknames, or pseudonyms) of any individuals involved. If
  there were other witnesses besides you, please try to include them as well.
  * Event details: when and where the incident occurred. Please be as specific
  as possible.
  * Your account of what occurred. If there is a publicly available record
  (e.g. a mailing list archive or a public IRC logger) please include a link.
  * Any extra context you believe existed for the incident.
  * If you believe this incident is ongoing.
  * Any other information you believe we should have.

When the affected party is constituted by more than one individual, a single
report gathering the contact information of all of them will need to be filled.

Event Incident Report
---------------------

When reporting Code violations occurred at ITK events (e.g. trainings,
hackathons), any Committee member that may be present or the designated event
delegate in their absence will need to send a report to the Committee
containing the following information:

  * Information about the ITK event where the Code incident occurred.
  * Date and time of the incident.
  * The contact information (so we can get in touch with you if we need to
  follow up) of the event delegate.
  * Names (real, nicknames, or pseudonyms) of any individuals involved.
  * Contact information of other witnesses, if any, of the incident.
  * The statement of what occurred. If there is a publicly available record
  (e.g. audiovisual material) please include the corresponding file.
  * Any extra context for the incident.
  * If this incident might be ongoing.
  * Any other relevant information (including other reports in case generated
  by third parties if applicable).
  * Actions taken.

The ISC Committee will then decide, according to the
[Report Handling](enforcement.md) procedure, whether the
incident response has been appropriate and the file needs to be closed or else,
whether further actions need to be taken.

Addressing Grievances
---------------------

If you feel you have been falsely or unfairly accused of violating this Code of
Conduct, you should notify the Committee with a concise description of your
grievance. Your grievance will be handled in accordance with the following ISC
Code of Conduct Committee procedure:

  1. Review the Code of Conduct incident report.
  2. Gather witnesses' statements about the incident or involve other
  colleagues as needed, or resource to mediation.
  3. Decide whether the incident response was appropriate, or else, whether
  actions need to be taken to amend the consequences on the accused party.

A report will be filled with the above information for the records.
