# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
ALPINE_RELEASES += 3
ALPINE_3_SUBVER = 21.2

.PHONY: all
all:: alpine-cloud-3.$(GARDEN_ARCH).qcow2 alpine-cloud-3.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/alpine/generic_alpine-3.$(ALPINE_3_SUBVER)-$(GARDEN_ARCH)-uefi-cloudinit-r0.qcow2

$(GARDEN_DL_DIR)/alpine/generic_alpine-3.$(ALPINE_3_SUBVER)-x86_64-uefi-cloudinit-r0.qcow2 $(GARDEN_DL_DIR)/alpine/generic_alpine-3.$(ALPINE_3_SUBVER)-aarch64-uefi-cloudinit-r0.qcow2: $(GARDEN_DL_DIR)/alpine/generic_alpine-3.$(ALPINE_3_SUBVER)-%-uefi-cloudinit-r0.qcow2: | $(GARDEN_DL_DIR)/alpine
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://dl-cdn.alpinelinux.org/alpine/v3.$(firstword $(subst ., ,$(ALPINE_3_SUBVER)))/releases/cloud/generic_alpine-3.$(ALPINE_3_SUBVER)-$*-uefi-cloudinit-r0.qcow2)

$(GARDEN_DL_DIR)/alpine/alpine-cloud-3.x86_64.qcow2: | $(GARDEN_DL_DIR)/alpine $(GARDEN_DL_DIR)/alpine/generic_alpine-3.$(ALPINE_3_SUBVER)-x86_64-uefi-cloudinit-r0.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/alpine/alpine-cloud-3.aarch64.qcow2: | $(GARDEN_DL_DIR)/alpine $(GARDEN_DL_DIR)/alpine/generic_alpine-3.$(ALPINE_3_SUBVER)-aarch64-uefi-cloudinit-r0.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/alpine/alpine-cloud-3.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/alpine/generic_alpine-3.$(ALPINE_3_SUBVER)-*-uefi-cloudinit-r0.qcow2
