# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
OPENSUSE_RELEASES ?=
GARDEN_SYSTEMS += $(foreach r,$(OPENSUSE_RELEASES),$(foreach a,x86_64 aarch64,opensuse-cloud-$r.$a))

$(foreach R,$(OPENSUSE_RELEASES),opensuse-cloud-$R.x86_64.run): opensuse-cloud-%.x86_64.run: $(MAKEFILE_LIST) | opensuse-cloud-%.x86_64.qcow2 opensuse-cloud-%.x86_64.efi-code.img opensuse-cloud-%.x86_64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/opensuse" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(OPENSUSE_RELEASES),opensuse-cloud-$R.aarch64.run): opensuse-cloud-%.aarch64.run: $(MAKEFILE_LIST) | opensuse-cloud-%.aarch64.qcow2 opensuse-cloud-%.aarch64.efi-code.img opensuse-cloud-%.aarch64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/opensuse" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

# Debian cloud images do not contain a standalone installer that you only need
# during the setup process. Instead each image can be used as a read-only base
# for a read-write template.
$(foreach R,$(OPENSUSE_RELEASES),opensuse-cloud-$R.x86_64.qcow2): opensuse-cloud-%.x86_64.qcow2: $(GARDEN_DL_DIR)/opensuse/opensuse-cloud-%.x86_64.qcow2 opensuse-cloud-%.seed.iso opensuse-cloud-%.x86_64.efi-code.img opensuse-cloud-%.x86_64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

# Replicated because we have more releases than architectures and architecture-specific quirks are easier to express.
$(foreach R,$(OPENSUSE_RELEASES),opensuse-cloud-$R.aarch64.qcow2): opensuse-cloud-%.aarch64.qcow2: $(GARDEN_DL_DIR)/opensuse/opensuse-cloud-%.aarch64.qcow2 opensuse-cloud-%.seed.iso opensuse-cloud-%.aarch64.efi-code.img opensuse-cloud-%.aarch64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

$(GARDEN_DL_DIR)/opensuse: | $(GARDEN_DL_DIR)
	mkdir -p $@

opensuse-cloud-%.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,opensuse-$*)
opensuse-cloud-%.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@

opensuse-cloud-%.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,OPENSUSE,$*),opensuse-$*,opensuse)
opensuse-cloud-%.user-data: $(MAKEFILE_LIST) $(wildcard .image-garden.mk)
	echo "$${USER_DATA}" | tee $@

.PHONY: clean
clean::
	rm -f $(foreach R,$(OPENSUSE_RELEASES),$(foreach A,x86_64 aarch64,opensuse-cloud-$R.$A.qcow2 opensuse-cloud-$R.$A.run))
