# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
ALMALINUX_RELEASES += 8

.PHONY: all
all:: almalinux-cloud-8.$(GARDEN_ARCH).qcow2 almalinux-cloud-8.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/almalinux/AlmaLinux-8-GenericCloud-latest.$(GARDEN_ARCH).qcow2

$(GARDEN_DL_DIR)/almalinux/AlmaLinux-8-GenericCloud-latest.x86_64.qcow2 $(GARDEN_DL_DIR)/almalinux/AlmaLinux-8-GenericCloud-latest.aarch64.qcow2: $(GARDEN_DL_DIR)/almalinux/AlmaLinux-8-GenericCloud-latest.%.qcow2: | $(GARDEN_DL_DIR)/almalinux
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://repo.almalinux.org/almalinux/8/cloud/$*/images/AlmaLinux-8-GenericCloud-latest.$*.qcow2)

$(GARDEN_DL_DIR)/almalinux/almalinux-cloud-8.x86_64.qcow2: | $(GARDEN_DL_DIR)/almalinux/ $(GARDEN_DL_DIR)/almalinux/AlmaLinux-8-GenericCloud-latest.x86_64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/almalinux/almalinux-cloud-8.aarch64.qcow2: | $(GARDEN_DL_DIR)/almalinux/ $(GARDEN_DL_DIR)/almalinux/AlmaLinux-8-GenericCloud-latest.aarch64.qcow2
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/almalinux/almalinux-cloud-8.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/almalinux/AlmaLinux-8-GenericCloud-latest.*.qcow2
