﻿// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the MIT license.  See License.txt in the project root for license information.

using System.Collections.Generic;
using System.Composition;
using System.Linq;
using Microsoft.CodeAnalysis.Analyzers.MetaAnalyzers.Fixers;
using Microsoft.CodeAnalysis.CodeFixes;
using Microsoft.CodeAnalysis.CSharp.Syntax;

namespace Microsoft.CodeAnalysis.CSharp.Analyzers.MetaAnalyzers.Fixers
{
    [ExportCodeFixProvider(LanguageNames.CSharp, Name = nameof(CSharpConfigureGeneratedCodeAnalysisFix)), Shared]
    public sealed class CSharpConfigureGeneratedCodeAnalysisFix : ConfigureGeneratedCodeAnalysisFix
    {
        protected override IEnumerable<SyntaxNode> GetStatements(SyntaxNode methodDeclaration)
        {
            if (methodDeclaration is MethodDeclarationSyntax method)
            {
                if (method.ExpressionBody != null)
                {
                    return new[] { method.ExpressionBody.Expression };
                }
                else if (method.Body != null)
                {
                    return method.Body.Statements;
                }
            }

            return Enumerable.Empty<SyntaxNode>();
        }
    }
}
