---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie,
              style des entrées bibliographiques
---

# Comment changer le style de la bibliographie ?

## Les fichiers de style bibliographique

Le style de la bibliographie est défini par la commande suivante :

```{noedit}
\bibliographystyle{⟨fichier⟩}
```

Son argument indique le `⟨fichier⟩` de style à utiliser : le fichier 
a pour extension BST mais cette extension ne doit pas être indiquée
dans cet argument. 

Les fichiers de style bibliographique sont lus par [BibTeX](ctanpkg:bibtex). 
Ils lui indiquent la mise en page à utiliser. Voici les caractéristiques 
des principaux styles :

- `abbrv.bst` : similaire au style `plain.bst` ci-dessous, 
  mais les prénoms des auteurs ainsi que les noms des mois sont abrégés ;
- `alpha.bst` : les clefs utilisées dans le document sont de la forme 
  "\[Lam94\]", et les références sont triées dans l'ordre alphabétique 
  des auteurs ;
- `apalike.bst` : les clefs utilisées sont constituées des noms complets 
  des auteurs, ainsi que de l'année. Le tri est fait suivant les noms 
  des auteurs. Ce style peut générer des labels longs qui ne devraient pas 
  être entourés de crochets. L'extension `apalike`, disponible  
  avec [BibTeX](ctanpkg:bibtex), permet de faire cette modification, illustrée
  à la question 
  "[](/3_composition/annexes/bibliographie/style_bst/choisir_un_style_de_bibliographie.md)" ;
- `plain.bst` : les clefs sont numériques (par exemple "\[12\]"). 
  Les références sont triées dans l'ordre alphabétique des auteurs ;
- `unsrt.bst` : clefs numériques. Les entrées ne sont pas triées, 
  elles apparaissent dans l'ordre où elles sont citées dans le document.

Pour trouver d'autres styles bibliographiques, consultez la question 
"[](/3_composition/annexes/bibliographie/style_bst/choisir_un_style_de_bibliographie)".


## Le style des citations

Ce sujet est évoqué et illustré à la question 
"[](/3_composition/annexes/bibliographie/references/configurer_la_commande)".