/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2025 Intel Corporation
 */

#ifndef __INTEL_CASF_REGS_H__
#define __INTEL_CASF_REGS_H__

#include "intel_display_reg_defs.h"

#define _SHARPNESS_CTL_A		0x682B0
#define _SHARPNESS_CTL_B		0x68AB0
#define SHARPNESS_CTL(pipe)		_MMIO_PIPE(pipe, _SHARPNESS_CTL_A, _SHARPNESS_CTL_B)
#define   FILTER_EN			REG_BIT(31)
#define   FILTER_STRENGTH_MASK		REG_GENMASK(15, 8)
#define   FILTER_STRENGTH(x)		REG_FIELD_PREP(FILTER_STRENGTH_MASK, (x))
#define   FILTER_SIZE_MASK		REG_GENMASK(1, 0)
#define   SHARPNESS_FILTER_SIZE_3X3	REG_FIELD_PREP(FILTER_SIZE_MASK, 0)
#define   SHARPNESS_FILTER_SIZE_5X5	REG_FIELD_PREP(FILTER_SIZE_MASK, 1)
#define   SHARPNESS_FILTER_SIZE_7X7	REG_FIELD_PREP(FILTER_SIZE_MASK, 2)

#define _SHRPLUT_DATA_A			0x682B8
#define _SHRPLUT_DATA_B			0x68AB8
#define SHRPLUT_DATA(pipe)		_MMIO_PIPE(pipe, _SHRPLUT_DATA_A, _SHRPLUT_DATA_B)

#define _SHRPLUT_INDEX_A		0x682B4
#define _SHRPLUT_INDEX_B		0x68AB4
#define SHRPLUT_INDEX(pipe)		_MMIO_PIPE(pipe, _SHRPLUT_INDEX_A, _SHRPLUT_INDEX_B)
#define   INDEX_AUTO_INCR		REG_BIT(10)
#define   INDEX_VALUE_MASK		REG_GENMASK(4, 0)
#define   INDEX_VALUE(x)		REG_FIELD_PREP(INDEX_VALUE_MASK, (x))

#endif /* __INTEL_CASF_REGS__ */
