# DevTools node tests

In addition to mochitests and xpcshell tests, some panels in DevTools are using node test libraries to run unit tests. For instance, several panels are using [Jest](https://jestjs.io/) to run React component unit tests.

## Find the node tests on Try

The DevTools node test task, `node(devtools)`, is running on the `Linux 64 opt` platform.
It is a tier 1 job, which means that any failure will lead to a backout.

## Run Tests On Try

To run the DevTools node tests on try, you can use `./mach try fuzzy` and look for the job named `source-test-node-devtools-tests`.

They are also run when using the "devtools" preset: `./mach try --preset devtools`.

### Node tests try job definition

The definition of those try jobs can be found at [taskcluster/kinds/source-test/node.yml](https://searchfox.org/mozilla-central/source/taskcluster/kinds/source-test/node.yml).

The definition also contains the list of files that will trigger the node test jobs. Currently the the devtools tests run when any file is modified under `devtools/client` or `devtools/shared`.

You will need yarn to be installed in order to run the DevTools tests. See [https://yarnpkg.com/getting-started](https://yarnpkg.com/getting-started).

To run the DevTools tests, use the mach command `devtools-node-test`:
```
> ./mach devtools-node-test --suite={suitename}
```

At the moment of writing, the supported suites for this script are:
- `aboutdebugging`
- `accessibility`
- `application`
- `compatibility`
- `debugger`
- `framework`
- `netmonitor`
- `performance`
- `shared_components`
- `webconsole`

You can run all the test suites by omitting the suite argument:
```
> ./mach devtools-node-test
```

## Updating snapshots

Some of the node tests are snapshot tests, which means they compare the output of a given component to a previous text snapshot. They might break if you are legitimately modifying a component and it means the snapshots need to be updated.

A snapshot failure will show up as follows:
```
› 1 snapshot failed from 1 test suite
```

It should also mention the command you can run to update the snapshots:
```
Inspect your code changes or run `yarn run test-ci -u` to update them.
```

For example, if you need to update snapshots in a specific panel, first locate the package.json corresponding to the node test folder of the panel. In theory it should be under `devtools/client/{panelname}/test/node/` but it might be slightly different depending on each panel. Then run `yarn run test-ci -u` in this folder and add the snapshot changes to your commit.

## TypeScript

The "performance" suite performs TypeScript checks. The TypeScript usage in the performance panel is documented at [devtools/client/performance-new/typescript.md](https://searchfox.org/mozilla-central/source/devtools/client/performance-new/typescript.md) ([see rendered version on GitHub](https://github.com/mozilla/gecko-dev/blob/master/devtools/client/performance-new/typescript.md)).

## devtools-bundle

The devtools-bundle job is a tier2 job which checks if DevTools bundles are outdated. DevTools bundles are generated JavaScript files built from other dependencies in tree in order to run in specific environments (typically a worker).

All the bundles used by DevTools are generated by devtools/client/debugger/bin/bundle.js. The devtools-bundle job is simply running this script and fails if any versioned file is updated.

In order to fix a failure, you should run the script:

```
> cd devtools/client/debugger/
> yarn && node bin/bundle.js
```

And commit the changes, either in the commit which updated the bundle dependencies, or in a separate commit in order to keep things separated.
