# Tutorials and Examples

mlpack has a number of examples, video tutorials, and other resources showing
usage of the library.

 * [mlpack examples repository](https://github.com/mlpack/examples/): contains
   simple examples of mlpack usage for various machine learning tasks, in C++
   and other languages.  Both notebooks and standalone programs are available.

---

 * [mlpack Youtube channel](https://www.youtube.com/@mlpack): tutorial videos
   for getting started with mlpack.
   - [Installing mlpack for use in C++](https://www.youtube.com/watch?v=wcEFce7IaS8):
     a step-by-step tutorial for installing and using mlpack from C++.
       * [Ubuntu/Debian](https://www.youtube.com/watch?v=wcEFce7IaS8&t=46s)
       * [Fedora/RHEL](https://www.youtube.com/watch?v=wcEFce7IaS8&t=188s)
       * [MacOS (via Homebrew)](https://www.youtube.com/watch?v=wcEFce7IaS8&t=303s)
       * [Installing from source](https://www.youtube.com/watch?v=wcEFce7IaS8&t=440s)
       * [Installing from source with the autodownloader](https://www.youtube.com/watch?v=wcEFce7IaS8&t=712s)

   - [Using mlpack for command-line data science](https://www.youtube.com/watch?v=M0DLrUVSyrE):
     a demonstration of mlpack's command-line bindings.

   - [Simple data science workflow in C++ with mlpack](https://www.youtube.com/watch?v=PD9AqGdkPl8):
     a tutorial using random forests and softmax regression in C++ to solve a
     simple data science problem.

   - [Development workflow tutorial: VSCode](https://www.youtube.com/watch?v=7DOrMQ2HhBY):
     set up an mlpack development environment in VSCode.  *This is useful if you
     are interested in contributing to mlpack.*

   - [Development workflow tutorial: command-line](https://www.youtube.com/watch?v=3PgFzA5duwc):
     set up an mlpack development environment from the command-line.  *This is
     useful if you are interested in contributing to mlpack.*

---

 * [mlpack models repository](https://github.com/mlpack/models/): contains
   implementations of specific deep learning models that are too large or
   complex for inclusion in the main mlpack library.
